using System.Collections.Generic;

namespace easyhr.service.domain
{
    public class Employee : Entity
    {
        protected Employee() {}

        public Employee(string first_name, string last_name)
        {
            FirstName = first_name;
            LastName = last_name;
            PreviousAddresses = new List<Address>();
        }

        public virtual string FirstName { get; set; }
        public virtual string LastName { get; set; }
        public virtual IList<Address> PreviousAddresses { get; set; }

        public virtual void ChangeAddressTo(string street, string city, string province, string postal_code)
        {
            PreviousAddresses.Add(new Address
                                  {
                                      Street = street,
                                      City = city,
                                      Province = province,
                                      PostalCode = postal_code,
                                  });
        }
    }
}