using System.Configuration;
using Castle.MicroKernel.Registration;
using Castle.Windsor;
using easyhr.service.orm.mappings;
using easyhr.service.orm.repositories;
using easyhr.service.orm.repositories.stubs;
using FluentNHibernate.Cfg;
using FluentNHibernate.Cfg.Db;
using NHibernate;
using NHibernate.ByteCode.Castle;
using NHibernate.Tool.hbm2ddl;
using utility;
using Configuration = NHibernate.Cfg.Configuration;

namespace easyhr.service.bootstrap
{
    public class ConfigureORM : ICommand
    {
        WindsorContainer container;

        public ConfigureORM(WindsorContainer container)
        {
            this.container = container;
        }

        public void Run()
        {
            var factory = Fluently
                .Configure()
                .Database(MsSqlConfiguration
                              .MsSql2005
                              .ConnectionString(ConfigurationManager.ConnectionStrings[ConfigurationManager.AppSettings["enabled.connection"]].ConnectionString)
                              .AdoNetBatchSize(500)
                              .ProxyFactoryFactory<ProxyFactoryFactory>())
                .Mappings(x => x.FluentMappings.AddFromAssemblyOf<MappingAssembly>())
                .ExposeConfiguration(x =>
                {
                    export(x);
                    x.SetProperty("current_session_context_class", "thread_static");
                })
                .BuildConfiguration()
                .BuildSessionFactory();

            //var context = new PerThread();
            container.Register(Component.For<IEmployeeRepository>().ImplementedBy<StubEmployeeRepository>().LifeStyle.Singleton);
            container.Register(Component.For<ISessionFactory>().Instance(factory));
            //container.Register(Component.For<IContext>().Instance(context));
            //container.Register(Component.For<ISession>().UsingFactoryMethod(() => context.value_for(new TypedKey<ISession>())).LifeStyle.Transient);
            //container.Register(Component.For<ISession>().UsingFactoryMethod(() => container.Resolve<ISessionFactory>().GetCurrentSession()));
            //container.Register(Component.For<IUnitOfWorkFactory>().ImplementedBy<NHibernateUnitOfWorkFactory>());
            //container.Register(Component.For<UnitOfWorkInterceptor>());
        }

        void export(Configuration configuration)
        {
            new SchemaUpdate(configuration).Execute(true, true);
            //new SchemaExport(configuration).Execute(true, true, false);
        }
    }
}
