﻿using Castle.Windsor;
using easyhr.service.bootstrap;
using NServiceBus;
using utility.extensions;

namespace easyhr.service
{
    public class ConfigureThisEndPoint : IConfigureThisEndpoint, AsA_Publisher, IWantCustomLogging
    {
        public void Init() {}
    }

    public class Initialize : IWantCustomInitialization
    {
        public void Init()
        {
            var container = new WindsorContainer();
            Configure.Instance.RijndaelEncryptionService();
            Configure
                .With()
                .Log4Net()
                .CastleWindsorBuilder(container)
                .XmlSerializer()
                .RijndaelEncryptionService()
                .MsmqTransport().IsTransactional(true).PurgeOnStartup(true)
                .MsmqSubscriptionStorage()
                .UnicastBus().ImpersonateSender(true).LoadMessageHandlers()
                .CreateBus()
                .Start()
                ;
            new ConfigureAutoMapper(container)
                .Then(new ConfigureORM(container))
                .Run();
        }
    }
}