using System;
using System.Collections.Generic;
using MetaWeblogApi;

namespace SpacesToDasBlog.ConsoleUI {
	internal class SpacesEntry : ISpacesEntry {
		public SpacesEntry( Post post )
			: this( post.postid, post.title, post.description, post.dateCreated, post.categories ) {}

		public SpacesEntry( string postid, string title, string description, DateTime dateCreated, string[] categories ) {
			_id = postid;
			_title = title;
			_body = description;
			_dateCreated = dateCreated;
			_categories = new List< string >( categories );
		}

		public string Id {
			get { return _id; }
		}

		public string Title {
			get { return _title; }
		}

		public string Body {
			get { return _body; }
		}

		public DateTime DateCreated {
			get { return _dateCreated; }
		}

		public IList< string > Categories {
			get { return _categories; }
		}

		private readonly string _id;
		private readonly string _title;
		private readonly string _body;
		private readonly DateTime _dateCreated;
		private readonly IList< string > _categories;
	}
}