using System;
using System.Configuration;

namespace SpacesToDasBlog.ConsoleUI {
	public class SpaceSettings {
		public SpaceSettings( )
			: this( ConfigurationManager.AppSettings[ "username" ],
			        ConfigurationManager.AppSettings[ "password" ],
			        ConfigurationManager.AppSettings[ "Category" ],
			        Convert.ToInt32( ConfigurationManager.AppSettings[ "UpperLimit" ] ),
			        ConfigurationManager.AppSettings[ "EntryIdPrefix" ],
			        ConfigurationManager.AppSettings[ "BlogUrl" ] ) {}

		public SpaceSettings( string username, string password, string defaultCategory, int upperLimit, string entryIdPrefix,
		                      string blogUrl ) {
			_username = username;
			_password = password;
			_defaultCategory = defaultCategory;
			_upperLimit = upperLimit;
			_entryIdPrefix = entryIdPrefix;
			_blogUrl = blogUrl;
		}

		public string Username {
			get { return _username; }
		}

		public string Password {
			get { return _password; }
		}

		public string DefaultCategory {
			get { return _defaultCategory; }
		}

		public int UpperLimit {
			get { return _upperLimit; }
		}

		public string EntryIdPrefix {
			get { return _entryIdPrefix; }
		}

		public string BlogUrl {
			get { return _blogUrl; }
		}

		private string _username;
		private string _password;
		private string _defaultCategory;
		private int _upperLimit;
		private string _entryIdPrefix;
		private string _blogUrl;
	}
}