using System;
using System.IO;
using System.Net;

namespace SpacesToDasBlog.ConsoleUI {
	public class SpaceHtmlParser {
		public SpaceHtmlParser( string blogUrl ) {
			_blogUrl = blogUrl;
		}

		public string BlogUrl {
			get { return _blogUrl; }
		}

		public DateTime GetEntryDate( string entryId ) {
			return GetEntryDate( entryId, GetPageHtml( entryId ) );
		}

		private static string GetTime( string html ) {
			int start = html.IndexOf( " AM" );
			start = ( start == -1 ) ? html.IndexOf( " PM" ) : start;
			start = start - 7;
			int end = start + 10;

			return html.Substring( start, end - start );
		}

		private static string GetMonthAndYear( string entryId, string responseFromServer ) {
			responseFromServer = responseFromServer.Substring( responseFromServer.IndexOf( "LastMDatecns!" + entryId ), 50 );
			int start = responseFromServer.IndexOf( ">" ) + 1;
			int end = responseFromServer.IndexOf( "<" );
			return responseFromServer.Substring( start, end - start ) + " 2005";
		}

		private static DateTime GetEntryDate( string entryId, string responseFromServer ) {
			string dateTime = GetMonthAndYear( entryId, responseFromServer ) + " " + GetTime( responseFromServer );
			DateTime result;
			if ( DateTime.TryParse( dateTime, out result ) ) {
				return result;
			}
			return DateTime.MinValue;
		}

		private string GetPageHtml( string entryId ) {
			WebResponse response = null;
			StreamReader reader = null;
			string responseFromServer;
			try {
				WebRequest request = WebRequest.Create( _blogUrl + entryId + ".entry" );
				response = request.GetResponse( );
				//Console.WriteLine( ( ( HttpWebResponse )response ).StatusDescription );

				Stream dataStream = response.GetResponseStream( );

				reader = new StreamReader( dataStream );
				responseFromServer = reader.ReadToEnd( );
				//Console.WriteLine( responseFromServer );
			}
			finally {
				if ( reader != null ) {
					reader.Close( );
				}
				if ( response != null ) {
					response.Close( );
				}
			}

			return responseFromServer;
		}

		private string _blogUrl;
	}
}