using System;
using System.Net;
using MetaWeblogApi;

namespace SpacesToDasBlog.ConsoleUI {
	internal class Program {
		/// <summary> The main entry point for the application. </summary> 
		[STAThread]
		private static void Main( ) {
			MsnSpacesMetaWeblog mw = new MsnSpacesMetaWeblog( );
			SpaceSettings settings = new SpaceSettings( );

			mw.Credentials = new NetworkCredential( settings.Username, settings.Password );

			DasBlogWriter dasBlogWriter = new DasBlogWriter( settings.DefaultCategory );
			SpaceHtmlParser parser = new SpaceHtmlParser( settings.BlogUrl );
			for ( int i = 0; i < settings.UpperLimit; i++ ) {
				string entryId = settings.EntryIdPrefix + i;
				try {
					Post post = mw.getPost( entryId, settings.Username, settings.Password );
					post.dateCreated = parser.GetEntryDate( entryId );
					
					dasBlogWriter.Write( new SpacesEntry( post ) );
					Console.WriteLine( "Success: Entry Id " + entryId );
				}
				catch {
					Console.WriteLine( "Failed to retrieve post with ID: " + entryId );
				}
			}
			Console.ReadLine( );
		}
	}
}