using System;
using newtelligence.DasBlog.Runtime;

namespace SpacesToDasBlog.ConsoleUI {
	public class DasBlogWriter {
		#region Constructors

		public DasBlogWriter( )
			: this( BlogDataServiceFactory.GetService( AppDomain.CurrentDomain.BaseDirectory, null ), "Journal" ) {}

		public DasBlogWriter( string defaultCategory )
			: this( BlogDataServiceFactory.GetService( AppDomain.CurrentDomain.BaseDirectory, null ), defaultCategory ) {}

		public DasBlogWriter( IBlogDataService service, String category ) {
			_service = service;
			_category = category;
		}

		#endregion

		#region Public Methods

		public void Write( ISpacesEntry spacesEntry ) {
			Entry entry = new Entry( );
			entry.CreatedLocalTime = spacesEntry.DateCreated;
			entry.ModifiedLocalTime = spacesEntry.DateCreated;
			entry.Title =
				( spacesEntry.Title.Length > 0
				  	? spacesEntry.Title
				  	: spacesEntry.Body.Substring( 0, Math.Min( 20, spacesEntry.Body.Length ) ) );
			entry.Content = spacesEntry.Body.Replace( Environment.NewLine, "<br />" );
			entry.EntryId = spacesEntry.Id;

			if ( spacesEntry.Categories.Count > 0 ) {
				foreach ( string category in spacesEntry.Categories ) {
					entry.Categories += category + ";";
				}
			}
			else {
				entry.Categories = _category;
			}
			entry.Author = "Mo";
			_service.SaveEntry( entry );
		}

		#endregion

		#region Private Fields

		private readonly IBlogDataService _service;
		private readonly string _category;

		#endregion
	}
}