using System.Collections.Generic;
using MbUnit.Framework;
using PlayingWithSpecifications.Core;

namespace PlayingWithSpecifications.Test {
	[TestFixture]
	public class QuestionBankTest {
		[Test]
		public void Should_Return_3_Questions_That_Are_Not_Math( ) {
			IEnumerable< IQuestion > matches =
				CreateSut( ).FindAllWhere( Question.IsIn( Any.Category ).But( Not.In( Category.Math ) ) );
			Assert.AreEqual( 3, GetCountFor( matches ) );
		}

		[Test]
		public void Should_Return_2_Science_Questions( ) {
			IEnumerable< IQuestion > matches = CreateSut( ).FindAllWhere( Question.IsIn( Category.Science ) );
			Assert.AreEqual( 2, GetCountFor( matches ) );
		}

		[Test]
		public void Should_Return_1_English_Questions( ) {
			IEnumerable< IQuestion > matches = CreateSut( ).FindAllWhere( Question.IsIn( Category.English ) );
			Assert.AreEqual( 1, GetCountFor( matches ) );
		}

		[Test]
		public void Should_Return_Not_Return_English_Questions( ) {
			IEnumerable< IQuestion > matches = CreateSut( ).FindAllWhere( Question.IsNotIn( Category.English ) );
			Assert.AreEqual( 4, GetCountFor( matches ) );
		}

		[Test]
		public void Should_Return_Questions_Not_In_Science( ) {
			IEnumerable< IQuestion > matches = CreateSut( ).FindAllWhere( Not.In( Category.Science ) );
			Assert.AreEqual( 3, GetCountFor( matches ) );
		}

		[Test]
		public void Should_Return_Questions_In_Science_Or_Math( ) {
			IEnumerable< IQuestion > matches =
				CreateSut( ).FindAllWhere( Question.IsIn( Category.Science ).Or( Question.IsIn( Category.Math ) ) );
			Assert.AreEqual( 4, GetCountFor( matches ) );
		}

		private int GetCountFor( IEnumerable< IQuestion > matches ) {
			return new List< IQuestion >( matches ).Count;
		}

		private IRepository< IQuestion > CreateSut( ) {
			IList< IQuestion > questions = new List< IQuestion >( );
			questions.Add( new Question( Category.Math ) );
			questions.Add( new Question( Category.Science ) );
			questions.Add( new Question( Category.English ) );
			questions.Add( new Question( Category.Math ) );
			questions.Add( new Question( Category.Science ) );

			return new QuestionBank( questions );
		}
	}
}