using System;

namespace PlayingWithSpecifications.Core {
	internal class Specification< T > : ISpecification< T > {
		private readonly Predicate< T > _criteria;

		public Specification( Predicate< T > criteria ) {
			_criteria = criteria;
		}

		public bool IsSatisfiedBy( T item ) {
			return _criteria( item );
		}

		public ISpecification< T > And( ISpecification< T > other ) {
			return new And< T >( this, other );
		}

		public ISpecification< T > Or( ISpecification< T > item ) {
			return new Or< T >( this, item );
		}

		public ISpecification< T > But( ISpecification< T > specification ) {
			return And( specification );
		}
	}
}