using System.Collections.Generic;

namespace PlayingWithSpecifications.Core {
	public class QuestionBank : IRepository< IQuestion > {
		public QuestionBank( IEnumerable< IQuestion > questions ) {
			_questions = questions;
		}

		public IEnumerable< IQuestion > FindAllWhere( ISpecification< IQuestion > specification ) {
			foreach ( IQuestion question in _questions ) {
				if ( specification.IsSatisfiedBy( question ) ) {
					yield return question;
				}
			}
		}

		private readonly IEnumerable< IQuestion > _questions;
	}
}