namespace PlayingWithSpecifications.Core {
	public class Question : IQuestion {
		public Question( ICategory category ) {
			_category = category;
		}

		public ICategory Category {
			get { return _category; }
		}

		public static ISpecification< IQuestion > IsIn( ICategory category ) {
			return Is.In( category );
		}

		public static ISpecification< IQuestion > IsNotIn( ICategory category ) {
			return Not.In( category );
		}

		private readonly ICategory _category;
	}
}