using System;

namespace PlayingWithSpecifications.Core {
	public class Category : ICategory, IEquatable< Category > {
		private Category( string name ) {
			_name = name;
		}

		public string Name {
			get { return _name; }
		}

		public static readonly ICategory Math = new Category( "Math" );
		public static readonly ICategory Science = new Category( "Science" );
		public static readonly ICategory English = new Category( "English" );

		public bool Equals( Category category ) {
			if ( category == null ) {
				return false;
			}
			return Equals( _name, category._name );
		}

		public override bool Equals( object obj ) {
			if ( ReferenceEquals( this, obj ) ) {
				return true;
			}
			return Equals( obj as Category );
		}

		public override int GetHashCode( ) {
			return _name.GetHashCode( );
		}

		private string _name;
	}
}