using MbUnit.Framework;
using PlayingWithServices.Core;
using Rhino.Mocks;

namespace PlayingWithServices.Test {
	[TestFixture]
	public class AuthenticationLoggerServiceTest {
		private MockRepository _mockery;

		[SetUp]
		public void Setup( ) {
			_mockery = new MockRepository( );
		}

		[RowTest]
		[Row( "mo", "password" )]
		[Row( "allison", "P@ssword" )]
		[Row( "adia", "skittles" )]
		public void Should_Log_Login_Attempt( string userName, string password ) {
			IAuthenticationService stubService = _mockery.Stub< IAuthenticationService >( );
			ILogger logger = _mockery.CreateMock< ILogger >( );

			using ( _mockery.Record( ) ) {
				logger.Write( "User Login Attempt: " + userName );
			}

			using ( _mockery.Playback( ) ) {
				CreateSut( logger, stubService ).CheckCredentials( userName, password );
			}
		}

		[RowTest]
		[Row( "mo", "password" )]
		[Row( "allison", "P@ssword" )]
		[Row( "adia", "skittles" )]
		public void Should_Delegate_Call_To_Actual_Service( string userName, string password ) {
			IAuthenticationService service = _mockery.CreateMock< IAuthenticationService >( );
			ILogger stubLogger = _mockery.Stub< ILogger >( );

			using ( _mockery.Record( ) ) {
				Expect.Call( service.CheckCredentials( userName, password ) ).Return( true )
					.Repeat.Once( );
			}

			using ( _mockery.Playback( ) ) {
				CreateSut( stubLogger, service ).CheckCredentials( userName, password );
			}
		}

		private AuthenticationLoggerService CreateSut( ILogger logger, IAuthenticationService service ) {
			return new AuthenticationLoggerService( service, logger );
		}
	}
}