using System.Collections.Generic;
using System.Security.Principal;

namespace PlayingWithServices.Core {
	internal class UserPrincipal : IPrincipal {
		public UserPrincipal( IIdentity identity, IEnumerable< IUserRole > roles ) {
			_identity = identity;
			_roles = ( null == roles ) ? new List< IUserRole >( ) : new List< IUserRole >( roles );
		}

		public IIdentity Identity {
			get { return _identity; }
		}

		public bool IsInRole( string role ) {
			return _roles.Exists( delegate( IUserRole userRole ) { return userRole.Name == role; } );
		}

		internal static IPrincipal CreateFor( IUser user ) {
			return new UserPrincipal( new UserIdentity( user.UserName, true ), user.GetRoles( ) );
		}

		private IIdentity _identity;
		private readonly List< IUserRole > _roles;
	}
}