using System.Security.Principal;

namespace PlayingWithServices.Core {
	internal class UserIdentity : IIdentity {
		public UserIdentity( string name, bool isAuthenticated ) {
			_name = name;
			_isAuthenticated = isAuthenticated;
		}

		public string Name {
			get { return _name; }
		}

		public string AuthenticationType {
			get { return "custom"; }
		}

		public bool IsAuthenticated {
			get { return _isAuthenticated; }
		}

		private string _name;
		private bool _isAuthenticated;
	}
}