namespace PlayingWithServices.Core {
	public class AuthenticationLoggerService : IAuthenticationService {
		public AuthenticationLoggerService( IAuthenticationService service, ILogger logger ) {
			_service = service;
			_logger = logger;
		}

		public bool CheckCredentials( string userName, string password ) {
			_logger.Write( "User Login Attempt: " + userName );
			return _service.CheckCredentials( userName, password );
		}

		private readonly IAuthenticationService _service;
		private readonly ILogger _logger;
	}
}