/*
 * Created by: Mo Khan
 * Created: Tuesday, May 08, 2007
 */
using System;
using GoogleDesktopAPILib;

namespace Sandbox.Properties
{
	public class GoogleAPIText
	{
		#region Web Example http://langexplr.blogspot.com/2007/04/using-google-desktop-from-net.html

		#endregion

		#region Public Methods

		private const Int32 GoogleCookie = 1030818419;

		public static int Register( )
		{
			Object[] description = new Object[] {
			                                    	"Title",
			                                    	" tests",
			                                    	"Description",
			                                    	"Simple tests",
			                                    	"Icon",
			                                    	"My Icon@1"
			                                    };

			const String applicationGuid = "{5323E036-345C-4323-548D-32AA55603212}";
			GoogleDesktopRegistrar registrar = new GoogleDesktopRegistrar( );

			registrar.StartComponentRegistration( applicationGuid, description );
			object regObjObj = registrar.GetRegistrationInterface( "GoogleDesktop.QueryRegistration" );

			IGoogleDesktopRegisterQueryPlugin query = regObjObj as IGoogleDesktopRegisterQueryPlugin;
			if( query == null ) {
				return 0;
			}
			else {
				Int32 cookie;
				cookie = query.RegisterPlugin( applicationGuid, true );
				registrar.FinishComponentRegistration( );
				return cookie;
			}
		}

		private class PropertyList
		{
			public const String ActualWork = "actual_work";
			public const String AlbumTitle = "album_title";
			public const String Artist = "artist";
			public const String Assistant = "assistant";
			public const String Attendees = "attendees";
			public const String Author = "author";
			public const String Categories = "categories";
			public const String Company = "company";
			public const String FolderName = "folder_name";
			public const String Format = "format";
			public const String IMAddress = "im_address";
			public const String Keywords = "keywords";
			public const String Language = "language";
			public const String LastModifiedTime = "last_modified_time";
			public const String Length = "length";
			public const String Location = "location";
		}

		public static void Search( String forText )
		{
			Int32 cookie = GoogleCookie;
			GoogleDesktopQueryAPI queryAPI = new GoogleDesktopQueryAPI( );
			IGoogleDesktopQueryResultSet results = queryAPI.Query( cookie, forText, "file", null );

			IGoogleDesktopQueryResultItem2 item;
			while( ( item = ( IGoogleDesktopQueryResultItem2 )results.Next( ) ) != null ) {
				Console.WriteLine( item.GetProperty( "uri" ) );
			}
		}

		#endregion
	}
}