using System;
using DesktopSearch.Task.Google;
using NUnit.Framework;

namespace DesktopSearch.Test.Task
{
	[TestFixture]
	public class GoogleDesktopQueryBuilderTest
	{
		private const String XmlFormat = "&format=xml";
		private const String MaxItems = "&num=";
		private const String FilesOnly = "type=cat_files"; // "&flags=512";
		private const String Directory = "&in=";
		private const String SearchText = "Microsoft";
		//http://127.0.0.1:4664/search&s=SFJNMLuPcNAwknyAszkB-ZEL-c0?q=&ie=UTF-8&btnG=Search

		// search for files
		// search for files in directory
		// search for 10 files in directory
		// search for 10 files

		[Test]
		public void BuildQuery_ShouldReturnQueryInXmlFormat( )
		{
			const String searchText = "Microsoft";

			QueryBuilder builder = new QueryBuilder( );
			String query = builder.Build( searchText );

			StringAssert.Contains( "http://127.0.0.1:4664/search&s=", query );
			StringAssert.Contains( XmlFormat, query );
		}

		[Test]
		public void BuildQuery_ShouldReturnQueryWithDirectoryFilter( )
		{
			String directory = Environment.SystemDirectory;
			String expectedDirectory =
				directory.Replace( ":", "%3A" ).Replace( "/", "%5C" ).Replace( " ", "+" ).Replace( "&", "and" ).Replace( @"\", "%5C" );

			QueryBuilder builder = new QueryBuilder( );
			builder.AddFilter( directory );
			String query = builder.Build( SearchText );

			StringAssert.Contains( "http://127.0.0.1:4664/search&s=", query );
			StringAssert.Contains( XmlFormat, query );
			StringAssert.Contains( Directory, query );
			StringAssert.Contains( expectedDirectory, query );
		}

		[Test]
		public void _ShouldReturnQueryForOnlyFiles( )
		{
			QueryBuilder builder = new QueryBuilder( );
			String query = builder.Build( SearchText );

			StringAssert.Contains( XmlFormat, query );
			StringAssert.Contains( FilesOnly, query );
		}

		[Test]
		public void _ShouldReturnQueryFor5Files( )
		{
			QueryBuilder builder = new QueryBuilder( );
			builder.AddFilter( 5 );
			String query = builder.Build( SearchText );

			StringAssert.Contains( XmlFormat, query );
			StringAssert.Contains( FilesOnly, query );
			StringAssert.Contains( MaxItems + "5", query );
		}
	}
}