/*
 * Created by: Mo Khan
 * Created: Friday, May 11, 2007
 */
using System;
using System.IO;
using DesktopSearch.Domain;
using DesktopSearch.Presentation;
using NUnit.Framework;
using Rhino.Mocks;
using Rhino.Mocks.Constraints;
using Rhino.Mocks.Interfaces;
using Telerik.WebControls;

namespace DesktopSearch.Test.Presentation
{
	[TestFixture]
	public class DirectoryTreePresenterTest
	{
		private MockRepository _mock;
		private IDirectoryTreeView _view;
		private IEventRaiser _initializeTreeEventRaiser;
		private IAppSettings _settings;

		[SetUp]
		public void SetUp( )
		{
			_mock = new MockRepository( );
			_view = _mock.CreateMock< IDirectoryTreeView >( );
			_settings = _mock.CreateMock< IAppSettings >( );

			// wire up Initialize Tree View
			_view.InitializeTreeView += null;
			LastCall.Constraints( Is.NotNull( ) );
			_initializeTreeEventRaiser = LastCall.GetEventRaiser( );
		}

		[TearDown]
		public void TearDown( )
		{
			_mock.VerifyAll( );
		}

		[Test]
		public void InitializeTreeView_ShouldLoadTreeViewWithDirectoriesStartingFromRootDocumentsDirector( )
		{
			String path = Path.GetTempPath( );
			Expect.Call( _settings.DocumentsPath ).Return( path ).Repeat.AtLeastOnce( );
			Expect.Call( _settings.VirtualPath ).Return( "http://google.ca/" ).Repeat.AtLeastOnce( );
			Expect.Call( _view.DirectoryTree ).PropertyBehavior( );
			_mock.ReplayAll( );

			new DirectoryTreePresenter( _view, _settings );
			_view.DirectoryTree = new RadTreeView( );
			_initializeTreeEventRaiser.Raise( null, null );
			Assert.IsNotNull( _view.DirectoryTree );
			foreach( RadTreeNode node in _view.DirectoryTree.Nodes ) {
				StringAssert.Contains( "http://google.ca/", node.Value, "This node does not contain the virtual path" );
				Assert.IsFalse( node.Value.IndexOf( path ) > 0, "This contains the orginal path instead of the virtual path." );
			}
		}
	}
}