using System;

namespace DesktopSearch.Domain
{
	/// <summary>This interface defines the properties of a document.</summary>
	public interface IDocument
	{
		/// <summary>The name of the file.</summary>
		String FileName { get; }

		/// <summary>The full path to the document.</summary>
		String FilePath { get; set; }

		/// <summary>Grabs a brief summary of the text from the file.</summary>
		String Summary { get; }

		/// <summary>The date the document was created on.</summary>
		DateTime CreatedDate { get; }

		/// <summary>The date the document was last modified on.</summary>
		DateTime ModifiedDate { get; }

		/// <summary>The size in bytes of the document.</summary>
		Double SizeBytes { get; }

		/// <summary>The file extension of the document.</summary>
		String FileExtension { get; }
	}
}