using System;
using System.Diagnostics;

namespace DesktopSearch.Domain
{
	/// <summary>This class refers to a document.</summary>
	[DebuggerDisplay( "Name = {_fileName}" )]
	public class Document : IDocument
	{
		#region Constructors

		/// <summary>Constructs and instance of this document and returns a reference to it.</summary>
		public Document( String fileName, String filePath, String summary,
		                 DateTime createdDate, DateTime modifiedDate, Double sizeBytes, String fileExtension )
		{
			FileName = fileName;
			FilePath = filePath;
			Summary = summary;
			CreatedDate = createdDate;
			ModifiedDate = modifiedDate;
			SizeBytes = sizeBytes;
			FileExtension = fileExtension;
		}

		#endregion

		#region Public Properties

		/// <summary>The name of the file.</summary>
		public String FileName
		{
			get { return _fileName; }
			private set { _fileName = value; }
		}

		/// <summary>The path to the file.</summary>
		public String FilePath
		{
			get { return _filePath; }
			set { _filePath = value; }
		}

		/// <summary>A sample of text from the document.</summary>
		public String Summary
		{
			get { return _summary; }
			private set { _summary = value; }
		}

		/// <summary>The date this document was created on.</summary>
		public DateTime CreatedDate
		{
			get { return _createdDate; }
			private set { _createdDate = value; }
		}

		/// <summary>The date this document was last modified on.</summary>
		public DateTime ModifiedDate
		{
			get { return _modifiedDate; }
			private set { _modifiedDate = value; }
		}

		/// <summary>The size in bytes of this document.</summary>
		public Double SizeBytes
		{
			get { return _sizeBytes; }
			private set { _sizeBytes = value; }
		}

		/// <summary>The file extension of this document.</summary>
		public String FileExtension
		{
			get { return _fileExtension; }
			private set { _fileExtension = value; }
		}

		#endregion

		#region Private Fields

		private String _fileName;
		private String _filePath;
		private String _summary;
		private DateTime _createdDate;
		private DateTime _modifiedDate;
		private Double _sizeBytes;
		private String _fileExtension;

		#endregion
	}
}