using System;
using System.Collections.Generic;
using DesktopSearch.Domain;

namespace DesktopSearch.Task
{
	public interface ISearchDocumentService
	{
		/// <summary>Searches for text in documents.</summary>
		/// <param name="forText">The text to search for in the indexed documents.</param>
		/// <returns>A collection of documents found containing the text to search for.</returns>
		ICollection< IDocument > Search( String forText );

		ICollection< IDocument > Search( String forText, String fromDirectory );
		ICollection< IDocument > SearchFor( String fileName );
		ICollection< IDocument > SearchFor( String fileName, String fromDirectory );
	}
}