/*
 * Created by: Mo Khan
 * Created: Wednesday, May 09, 2007
 */

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Globalization;
using System.Xml;
using DesktopSearch.Domain;

namespace DesktopSearch.Task.Google
{
	public class ResultsParser : IResultsParser
	{
		#region Public Methods

		public ICollection< GoogleSearchResult > ParseResultsXml( String resultsXml )
		{
			XmlDocument document = new XmlDocument( );
			document.LoadXml( resultsXml );
			return ParseResults( document );
		}

		public IEnumerable< GoogleSearchResult > Parse( String xml )
		{
			XmlDocument document = new XmlDocument( );
			document.LoadXml( xml );
			return ParseResults( document );
		}

		public IEnumerable< GoogleSearchResult > Parse( XmlDocument xml )
		{
			return ParseResults( xml );
		}

		public GoogleSearchResult ParseSingle( String resultXmlRecord )
		{
			if( String.IsNullOrEmpty( resultXmlRecord ) ) {
				return null;
			}
			XmlDocument document = new XmlDocument( );
			document.LoadXml( resultXmlRecord );
			XmlNodeReader reader = new XmlNodeReader( document );

			GoogleSearchResult result = new GoogleSearchResult( );
			reader.MoveToContent( );
			try {
				while( reader.Read( ) ) {
					if( reader.NodeType == XmlNodeType.Element ) {
						switch( reader.LocalName.ToLower( CultureInfo.InvariantCulture ) ) {
							case ResultsXmlElement.Category:
								result.Category = reader.ReadString( );
								break;
							case ResultsXmlElement.DocumentId:
								result.DocumentId = Convert.ToInt32( reader.ReadString( ), CultureInfo.InvariantCulture );
								break;
							case ResultsXmlElement.EventId:
								result.EventId = Convert.ToInt32( reader.ReadString( ), CultureInfo.InvariantCulture );
								break;
							case ResultsXmlElement.Title:
								result.Title = reader.ReadString( );
								break;
							case ResultsXmlElement.Url:
								result.Url = new Uri( reader.ReadString( ) );
								break;
							case ResultsXmlElement.Flags:
								result.Flags = Convert.ToInt32( reader.ReadString( ), CultureInfo.InvariantCulture );
								break;
							case ResultsXmlElement.Time:
								result.Time = Convert.ToDouble( reader.ReadString( ), CultureInfo.InvariantCulture );
								break;
							case ResultsXmlElement.Snippet:
								result.Snippet = reader.ReadString( );
								break;
							case ResultsXmlElement.Thumbnail:
								result.Thumbnail = reader.ReadString( );
								break;
							case ResultsXmlElement.Icon:
								result.Icon = reader.ReadString( );
								break;
							case ResultsXmlElement.CacheUrl:
								result.CacheUrl = new Uri( reader.ReadString( ) );
								break;
						}
					}
				}
				return result;
			}
			catch( FormatException ) {
				return null;
			}
		}

		#endregion

		#region Private Fields

		#endregion

		#region Private Methods

		private ICollection< GoogleSearchResult > ParseResults( XmlDocument document )
		{
			XmlNodeReader reader = new XmlNodeReader( document );

			reader.MoveToContent( );
			reader.Read( );
			if( reader.NodeType == XmlNodeType.Element ) {
				if( String.Compare( reader.LocalName, "result", true, CultureInfo.InvariantCulture ) == 0 ) {
					ICollection< GoogleSearchResult > results = new Collection< GoogleSearchResult >( );
					String resultNode;
					while( !String.IsNullOrEmpty( resultNode = reader.ReadOuterXml( ) ) ) {
						GoogleSearchResult result = ParseSingle( resultNode );
						if( null != result ) {
							results.Add( result );
						}
						else {
							Console.WriteLine( resultNode );
						}
					}
					return results;
				}
			}

			return null;
		}

		#endregion
	}
}