/*
 * Created by: Mo Khan
 * Created: Thursday, May 03, 2007
 */

using System;
using Microsoft.Win32;

namespace DesktopSearch.Task.Google
{
	public class QueryBuilder
	{
		#region Constructors

		public QueryBuilder( ) {}

		public QueryBuilder( String directory ) : this( directory, Int32.MaxValue ) {}

		public QueryBuilder( Int32 numberOfItems ) : this( String.Empty, numberOfItems ) {}

		public QueryBuilder( String directory, Int32 numberOfItems )
		{
			AddDirectoryFilter( directory );
			AddMaxItemsFilter( numberOfItems );
		}

		#endregion

		#region Public Methods

		public void AddFilter( String directory )
		{
			AddDirectoryFilter( directory );
		}

		public void AddFilter( Int32 numberOfItems )
		{
			AddMaxItemsFilter( numberOfItems );
		}

		public String Build( String searchText )
		{
			String query =
				GetGoogleDesktopSearchUrl( )
				+ "&adv=1&type=cat_files&ot=&file=&ext=&in="
				+ ( !String.IsNullOrEmpty( _directory ) ? _directory : String.Empty )
				+ "&under=on&to=&from=&domain=&has=" + searchText + "&no=&within=86400&day=&format=xml"
				+ ( _numberofItems != 0 ? "&num=" + _numberofItems : String.Empty );

			return query;
		}

		#endregion

		#region Private Fields

		private Int32 _numberofItems;
		private String _directory;

		#endregion

		#region Private Methods

		private static String GetGoogleDesktopSearchUrl( )
		{
			RegistryKey currentUser = RegistryKey.OpenRemoteBaseKey( RegistryHive.CurrentUser, String.Empty );
			RegistryKey searchUrl = currentUser.OpenSubKey( "Software\\Google\\Google Desktop\\API" );
			Object key = searchUrl.GetValue( "search_url" );
			if( null != key ) {
				return key.ToString( );
			}
			return String.Empty;
		}

		private void AddDirectoryFilter( String directory )
		{
			_directory =
				directory.Replace( ":", "%3A" ).Replace( "/", "%5C" ).Replace( " ", "+" ).Replace( "&", "and" ).Replace( @"\", "%5C" );
		}

		private void AddMaxItemsFilter( Int32 numberOfItems )
		{
			_numberofItems = numberOfItems;
		}

		#endregion
	}
}