/*
 * Created by: Mo Khan
 * Created: Tuesday, May 08, 2007
 */

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Runtime.InteropServices;
using System.Text;
using DesktopSearch.Domain;
using DesktopSearch.Task.Google;
using DesktopSearch.Task.Google.Interop;
using GoogleDesktopAPILib;

namespace DesktopSearch.Task.Google.Interop
{
	public class GoogleSearchDocumentService : ISearchDocumentService
	{
		#region Public Methods

		public ICollection< IDocument > Search( String forText )
		{
			Int32 cookie = SearchRegistrar.GoogleCookie;
			GoogleDesktopQueryAPI query = new GoogleDesktopQueryAPI( );
			IGoogleDesktopQueryResultSet results = query.Query( cookie, forText, "file", Ranking.Relevance );

			IGoogleDesktopQueryResultItem2 item;
			ICollection< IDocument > documents = new Collection< IDocument >( );
			while( ( ReadyState )results.readystate != ReadyState.Complete ) {
				;
			}

			while( ( item = ( IGoogleDesktopQueryResultItem2 )results.Next( ) ) != null ) {
				GetAvailableProperties( item );
				switch( item.schema ) {
					case Schema.Text:

						break;
					case Schema.File:
						//Document document = GetDocument( forText, item );
						//if( null != document ) {
						//    documents.Add( document );
						//}
						break;
					case Schema.Media:

						break;
					default:
						break;
				}
				//IGoogleDesktopQueryResultItem itemVersion = item.versions.Item( 0 );
			}
			WriteToFile( );
			return documents;
		}

		public ICollection< IDocument > Search( String forText, String fromDirectory )
		{
			throw new NotImplementedException( );
		}

		public ICollection< IDocument > SearchFor( String fileName )
		{
			throw new NotImplementedException( );
		}

		public ICollection< IDocument > SearchFor( String fileName, String fromDirectory )
		{
			throw new NotImplementedException( );
		}

		#endregion

		#region Private Fields

		private enum Ranking
		{
			Relevance = 0,
			Recency = 1
		}

		private enum ReadyState
		{
			Uninitialized = 0,
			Loading = 1,
			Complete = 2
		}

		#endregion

		#region Private Methods

		private static Document GetDocument( String forText, IGoogleDesktopQueryResultItem2 item )
		{
			try {
				DateTime lastModified = ( DateTime )item.GetProperty( PropertyList.LastModifiedTime );
				String url = ( String )item.GetProperty( PropertyList.Uri );
				String itemSnippet = item.GetSnippet( 250, forText );
				Uri uri = new Uri( url );
				String fileName = uri.Segments[ uri.Segments.Length - 1 ];
				String fileExtention = ParseFileExtension( fileName );
				return new Document( fileName,
				                     url,
				                     itemSnippet,
				                     lastModified,
				                     ( DateTime )item.GetProperty( PropertyList.TimeStamp ),
				                     //( Int32 )item.GetProperty( GooglePropertyList.Length ),
				                     0,
				                     fileExtention
					);
			}
			catch( ArgumentException ) {
				return null;
			}
			catch( COMException ) {
				return null;
			}
		}

		private static String ParseFileExtension( String fileName )
		{
			return fileName.Substring( fileName.LastIndexOf( "." ) + 1 );
		}

		private Collection< String > fileProperties = new Collection< String >( );
		private Collection< String > textProperties = new Collection< String >( );
		private Collection< String > mediaProperties = new Collection< String >( );

		private void GetAvailableProperties( IGoogleDesktopQueryResultItem2 item )
		{
			PropertyList properties = new PropertyList( );

			for( Int32 i__ = 1; i__ < 116; i__++ ) {
				try {
					String s = ( String )item.GetProperty( properties[ i__ ] );

					switch( item.schema ) {
						case Schema.File:
							if( !fileProperties.Contains( properties[ i__ ] ) ) {
								fileProperties.Add( properties[ i__ ] );
							}
							break;
						case Schema.Media:
							if( !mediaProperties.Contains( properties[ i__ ] ) ) {
								mediaProperties.Add( properties[ i__ ] );
							}
							break;
						case Schema.Text:
							if( !textProperties.Contains( properties[ i__ ] ) ) {
								textProperties.Add( properties[ i__ ] );
							}
							break;
					}
				}
				catch {}
				// suppress so that we can iterate through all the properties... only for testing... usually this is bad practice!
			}
		}

		private void WriteToFile( )
		{
			StringBuilder builder = new StringBuilder( );
			foreach( string s in fileProperties ) {
				builder.Append( s + Environment.NewLine );
			}
			File.WriteAllText( Path.Combine( Environment.CurrentDirectory, "fileProperties.txt" ), builder.ToString( ) );

			builder = new StringBuilder( );
			foreach( string s in textProperties ) {
				builder.Append( s + Environment.NewLine );
			}
			File.WriteAllText( Path.Combine( Environment.CurrentDirectory, "textProperties.txt" ), builder.ToString( ) );

			builder = new StringBuilder( );
			foreach( string s in mediaProperties ) {
				builder.Append( s + Environment.NewLine );
			}
			File.WriteAllText( Path.Combine( Environment.CurrentDirectory, "fileProperties.txt" ), builder.ToString( ) );
		}

		#endregion
	}
}