/*
 * Created by: Mo Khan
 * Created: Friday, May 04, 2007
 */

using System;
using System.Collections.Generic;
using System.Data;
using System.Globalization;
using DesktopSearch.Domain;
using DesktopSearch.Task;

namespace DesktopSearch.Presentation
{
	public class SearchPresenter
	{
		#region Constructors

		public SearchPresenter( ISearchView view, ISearchDocumentService service ) : this( view, service, null ) {}

		public SearchPresenter( ISearchView view, ISearchDocumentService service, IAppSettings settings )
		{
			if( null == view ) {
				throw new ArgumentNullException( "view" );
			}
			if( null == service ) {
				throw new ArgumentNullException( "task" );
			}
			//if( null == settings ) {
			//    throw new ArgumentNullException( "settings" );
			//}
			_view = view;
			_task = service;
			//_settings = settings;
			_view.SearchButtonClick += delegate { SearchClick( ); };
			_view.Load += delegate { Page_Load( ); };
		}

		#endregion

		#region Public Methods

		public void Search( )
		{
			SearchForDocuments( );
		}

		public void DataBind( ICollection< IDocument > documents )
		{
			if( null != documents ) {
				AddResultsToTable( documents );
			}
			_view.DataBind( );
		}

		#endregion

		#region Private Fields

		private ISearchView _view;
		private ISearchDocumentService _task;
		//private IAppSettings _settings;

		#endregion

		#region Private Methods

		private ICollection< IDocument > SearchForDocuments( )
		{
			ICollection< IDocument > documents;
			if( _view.FileNameSearch ) {
				documents = ( _view.FromDirectory )
				            	? _task.SearchFor( _view.SearchText, _view.SearchInDirectory )
				            	: _task.SearchFor( _view.SearchText );
			}
			else {
				documents = ( _view.FromDirectory )
				            	? _task.Search( _view.SearchText, _view.SearchInDirectory )
				            	: _task.Search( _view.SearchText );
			}
			_view.TotalResults = ( null != documents ) ? documents.Count : 0;
			return documents;
		}

		private static DataTable BuildTable( )
		{
			DataTable table = new DataTable( );
			table.Locale = CultureInfo.InvariantCulture;
			table.Columns.Add( SearchPresenterColumns.Title );
			table.Columns.Add( SearchPresenterColumns.Path );
			table.Columns.Add( SearchPresenterColumns.SampleText );
			table.Columns.Add( SearchPresenterColumns.CreatedDate );
			table.Columns.Add( SearchPresenterColumns.ModifiedDate );
			return table;
		}

		private void AddResultsToTable( ICollection< IDocument > documents )
		{
			DataTable results = BuildTable( );
			foreach( IDocument document in documents ) {
				DataRow row = results.NewRow( );
				row[ SearchPresenterColumns.CreatedDate ] = document.CreatedDate;
				row[ SearchPresenterColumns.ModifiedDate ] = document.ModifiedDate;
				row[ SearchPresenterColumns.Path ] = document.FilePath;
				row[ SearchPresenterColumns.SampleText ] = document.Summary;
				row[ SearchPresenterColumns.Title ] = document.FileName;

				results.Rows.Add( row );
			}
			_view.Results = results;
		}

		#endregion

		#region Event Handlers

		private void SearchClick( )
		{
			ICollection< IDocument > documents = SearchForDocuments( );
			DataBind( documents );
		}

		private static void Page_Load( ) {}

		#endregion
	}
}