using System;
using System.Threading;

namespace Sait.Cmpp297.Assignment1.DeadLock {
	internal class Program {
		private static void Main( ) {
			Deadlocker deadlock = new Deadlocker( );

			Thread first = new Thread( new ThreadStart( deadlock.First ) );
			Thread second = new Thread( new ThreadStart( deadlock.Second ) );
			first.Start( );
			second.Start( );

			first.Join( );
			second.Join( );
		}
	}

	/// <summary>
	/// 1. First thread starts and locks resourceA
	/// 2. Second thread starts and locks resourceB
	/// 3. First thread blocks waiting for resourceB to be freed.
	/// 4. Second thread blocks waiting for resourceA to be freed.
	/// 5. The application stops in it's tracks.
	/// </summary>
	internal class Deadlocker {
		#region Public Methods

		public void First( ) {
			lock ( _resourceA ) {
				lock ( ( _resourceB ) ) {
					Console.WriteLine( "First" );
				}
			}
		}

		public void Second( ) {
			lock ( _resourceB ) {
				lock ( ( _resourceA ) ) {
					Console.WriteLine( "Second" );
				}
			}
		}

		#endregion

		#region Private Fields

		private object _resourceA = new object( );
		private object _resourceB = new object( );

		#endregion
	}
}